<?php
include 'conexao.php';

// --- Processamento de Ações (Deletar e Editar) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'delete' && isset($_POST['disciplina_id'])) {
        $disciplina_id = $_POST['disciplina_id'];
        
        // Inicia uma transação para garantir que ambas as operações sejam bem-sucedidas ou nenhuma seja
        $conn->begin_transaction();

        try {
            // 1. Apagar as atribuições relacionadas na tabela 'atribuicoes'
            $stmt_atribuicoes = $conn->prepare("DELETE FROM atribuicoes WHERE disciplina_id = ?");
            $stmt_atribuicoes->bind_param("i", $disciplina_id);
            $stmt_atribuicoes->execute();
            $stmt_atribuicoes->close();

            // 2. Apagar a disciplina na tabela 'disciplinas'
            $stmt_disciplina = $conn->prepare("DELETE FROM disciplinas WHERE id = ?");
            $stmt_disciplina->bind_param("i", $disciplina_id);
            $stmt_disciplina->execute();
            $stmt_disciplina->close();

            // Confirma as operações
            $conn->commit();
            echo "<script>alert('Disciplina e suas atribuições apagadas com sucesso!');</script>";

        } catch (mysqli_sql_exception $e) {
            // Reverte em caso de erro
            $conn->rollback();
            echo "<script>alert('Erro ao apagar a disciplina: " . htmlspecialchars($e->getMessage()) . "');</script>";
        }

    } elseif ($_POST['action'] === 'edit' && isset($_POST['disciplina_id']) && isset($_POST['nova_turma_id'])) {
        $disciplina_id = $_POST['disciplina_id'];
        $nova_turma_id = $_POST['nova_turma_id'];
        $stmt = $conn->prepare("UPDATE disciplinas SET turma_id = ? WHERE id = ?");
        $stmt->bind_param("ii", $nova_turma_id, $disciplina_id);
        $stmt->execute();
        echo "<script>alert('Disciplina atualizada com sucesso!');</script>";
    }
}
// --- Processamento do Formulário de Cadastro ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nome']) && isset($_POST['turma_id'])) {
    $turma_id = $_POST['turma_id'] ?? '';
    $nome = $_POST['nome'] ?? '';
    if ($turma_id && $nome) {
        $stmt = $conn->prepare("INSERT INTO disciplinas (turma_id, nome) VALUES (?, ?)");
        $stmt->bind_param("is", $turma_id, $nome);
        $stmt->execute();
        echo "<script>alert('Disciplina salva com sucesso!');</script>";
    } else {
        echo "<script>alert('Preencha todos os campos.');</script>";
    }
}

// --- Busca de Dados para Exibição ---
// Buscar todas as turmas
$sql_turmas = "SELECT id, nome, ano, classe, curso FROM turmas ORDER BY ano DESC, nome ASC";
$turmas = $conn->query($sql_turmas);

// Buscar todas as disciplinas, juntando com o nome da turma
$sql_disciplinas = "
    SELECT d.id, d.nome AS nome_disciplina, t.nome AS nome_turma, t.classe, t.curso
    FROM disciplinas d
    JOIN turmas t ON d.turma_id = t.id
    ORDER BY t.ano DESC, t.nome ASC, d.nome ASC
";
$disciplinas = $conn->query($sql_disciplinas);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Disciplinas</title>
    <style>
        body { margin: 0; font-family: Arial, sans-serif; }
        .top-bar { background: #0056b3; color: white; padding: 15px; font-size: 18px; }
        .sidebar { width: 220px; background: #1c1c1c; height: 100vh; float: left; padding-top: 20px; }
        .sidebar a { display: block; color: white; padding: 10px 20px; text-decoration: none; }
        .sidebar a:hover { background: #333; }
        .content { margin-left: 220px; padding: 20px; background: #f4f4f4; min-height: 100vh; }
        .form-box, .list-box { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 0 5px #ccc; max-width: 800px; margin-bottom: 20px; }
        input[type="text"], select { width: 100%; padding: 8px; margin: 6px 0; }
        button, .action-button { padding: 10px 15px; background: #0056b3; color: white; border: none; cursor: pointer; margin-right: 5px; border-radius: 4px; }
        button:hover, .action-button:hover { background: #004494; }
        .nav-links a { margin-right: 10px; color: #0056b3; text-decoration: none; }
        .nav-links a:hover { text-decoration: underline; }
        .list-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .list-table th, .list-table td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        .list-table th { background-color: #f2f2f2; }
        .delete-button { background-color: #e74c3c; }
        .delete-button:hover { background-color: #c0392b; }
        .edit-form { display: flex; align-items: center; gap: 10px; }
        .edit-form select { width: 200px; }
    </style>
</head>
<body>

<div class="top-bar">SISMAG - Gerenciar Disciplinas</div>

<div class="sidebar">
    <a href="painel.php">🏠 Início</a>
    <a href="cadastrar_turma1.php">🏫 Cadastrar Turmas</a>
    <a href="cadastrar_aluno.php">👨‍🎓 Cadastrar Alunos</a>
    <a href="matricular_aluno.php">📋 Ver Alunos</a>
</div>

<div class="content">
    <div class="form-box">
        <h2>Nova Disciplina</h2>
        <form method="POST">
            <label>Turma:</label>
            <select name="turma_id" required>
                <option value="">-- Selecione uma turma --</option>
                <?php $turmas->data_seek(0); // Reinicia o ponteiro ?>
                <?php while ($row = $turmas->fetch_assoc()): ?>
                    <option value="<?= $row['id'] ?>">
                        <?= $row['classe'] . 'ª - ' . $row['curso'] . ' - ' . $row['nome'] ?>
                    </option>
                <?php endwhile; ?>
            </select>
            <label>Nome da Disciplina:</label>
            <input name="nome" type="text" required>
            <button type="submit">Salvar</button>
        </form>
    </div>

    <div class="list-box">
        <h2>Disciplinas Cadastradas 📋</h2>
        <?php if ($disciplinas->num_rows > 0): ?>
            <table class="list-table">
                <thead>
                    <tr>
                        <th>Disciplina</th>
                        <th>Turma (Atual)</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $disciplinas->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['nome_disciplina']) ?></td>
                            <td><?= htmlspecialchars($row['classe'] . 'ª - ' . $row['curso'] . ' - ' . $row['nome_turma']) ?></td>
                            <td>
                                <form method="POST" style="display:inline;" onsubmit="return confirm('Tem certeza que deseja apagar a disciplina \'<?= addslashes($row['nome_disciplina']) ?>\'?');">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="disciplina_id" value="<?= $row['id'] ?>">
                                    <button type="submit" class="action-button delete-button">Apagar 🗑️</button>
                                </form>
                                <form method="POST" class="edit-form" style="display:inline;">
                                    <input type="hidden" name="action" value="edit">
                                    <input type="hidden" name="disciplina_id" value="<?= $row['id'] ?>">
                                    <select name="nova_turma_id" required>
                                        <?php $turmas->data_seek(0); // Reinicia o ponteiro para a lista de turmas ?>
                                        <?php while ($turma = $turmas->fetch_assoc()): ?>
                                            <option value="<?= $turma['id'] ?>">
                                                Mudar para: <?= $turma['classe'] . 'ª - ' . $turma['curso'] . ' - ' . $turma['nome'] ?>
                                            </option>
                                        <?php endwhile; ?>
                                    </select>
                                    <button type="submit" class="action-button">Alterar</button>
                                </form>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Nenhuma disciplina cadastrada ainda.</p>
        <?php endif; ?>
    </div>
</div>

</body>
</html>